import QtQuick 2.12
import QtQuick.Window 2.12

Window {
    visible: true
    width: 640
    height: 480
    title: qsTr("Medish Demo")

    Rectangle {
        id: headerBar
        anchors {
            top: parent.top
            left: parent.left; right: parent.right
        }
        height: parent.height * 0.08
        Rectangle {
            id: dateTimeBox
            anchors.fill: parent
            color: "green"
            Text {
                id: txt_currentDate
                anchors.verticalCenter: parent.verticalCenter
                anchors.left: parent.left
                anchors.leftMargin: 3
                text: dateTime.currentDate
                color: "purple"
                font.pixelSize: parent.height * 0.6
            }

            Text {
                id: txt_currentTime
                anchors.verticalCenter: parent.verticalCenter
                anchors.right: parent.right
                anchors.rightMargin: 3
                text: dateTime.currentTime
                color: "purple"
                font.pixelSize: parent.height * 0.6
            }
        }
    }

    Rectangle {
        id: mainContent
        anchors{ top: headerBar.bottom; bottom: parent.bottom; left: parent.left; right: parent.right }
        color: "cyan"
    }
}
